--[[----------------------------------------------------------------------------

SampleTetherServiceProvider.lua
Tether service provider description for Lightroom sample Tether plugin

--------------------------------------------------------------------------------

ADOBE SYSTEMS INCORPORATED
 Copyright 2007-2008 Adobe Systems Incorporated
 All Rights Reserved.

NOTICE: Adobe permits you to use, modify, and distribute this file in accordance
with the terms of the Adobe license agreement accompanying it. If you have received
this file from a source other than Adobe, then your use, modification, or distribution
of it requires the prior written permission of Adobe.

------------------------------------------------------------------------------]]

	-- Lightroom SDK

	-- Sample plug-in
require 'LeicaTetherTask'


--============================================================================--

return {

	init = LeicaTetherTask.init,
	shutdown = LeicaTetherTask.shutdown,
	
	setCallback = LeicaTetherTask.setCallback,
	
	
	startDeviceSearch = LeicaTetherTask.startDeviceSearch,
	stopDeviceSearch = LeicaTetherTask.stopDeviceSearch,
	queryDevices = LeicaTetherTask.queryDevices,
	connectDevice = LeicaTetherTask.connectDevice,
	disconnectDevice = LeicaTetherTask.disconnectDevice,
	getCameraSettings = LeicaTetherTask.getCameraSettings,
	
	doCapture = LeicaTetherTask.doCapture,
	
	pollForMessages = LeicaTetherTask.pollForMessages,
	
	
--------------------------------------------------------------------------------
--- Host is asking to download the thumbnail of the image.
 -- <p>First supported in version 3.0 of the Lightroom SDK.</p>
	-- @name TetherTask.downloadThumbnail
	-- @class function
	-- @param deviceId (string) The device ID
	-- @param captureId (string) The capture ID provided by the plugin 
		-- when doCapture was called
	-- @return (table) A table consisting of the following fields
		-- status (string) - required - A string of one of: 
			-- 'notReady': Plugin isn't ready to provide the thumbnail yet, but
				-- is still planning to
			-- 'cannotProvide': For some reason the plugin can't provide the
				-- thumbnail, but the captured file may still be downloaded
			-- 'error':  There was an error on capture, and the download of the
				-- captured file should not be attempted
			-- 'ok': The thumbnail data is being provided
		-- thumbnailData (binary string) The JPEG data of the thumbnail
			-- This parameter should only be provided if the status was 'ok'
		-- errorMsg (string) A string describing the error that occurred
			-- This parameter should only be provided if the status was 'error'.
	
	downloadThumbnail = LeicaTetherTask.downloadThumbnail,
	
	
	
--------------------------------------------------------------------------------
--- Host is asking for some info about this image before download.
 -- <p>First supported in version 3.0 of the Lightroom SDK.</p>
	-- @name TetherTask.getCaptureInfo
	-- @class function
	-- @param deviceId (string) The device ID
	-- @param captureId (string) The capture ID provided by the plugin 
		-- when doCapture was called
	-- @return (table) A table consisting of the following fields
		-- status (string) - required - A string of one of: 
			-- 'notReady': Plugin isn't ready to provide this info yet. The
				-- download of the file will not progress until the plugin
				-- provides this data.
			-- 'error':  There was an error on capture, and the download of the
				-- captured file should not be attempted
			-- 'ok': The image data is being provided
		-- fileType (string) The file type for the image. This would generally
			-- be the file extension for the downloaded file, such as 
			-- 'CR2', 'NRW', 'JPG', etc.
			-- This parameter should only be provided if the status was 'ok'
		-- fileLength (number) The total size of the image file
			-- This parameter should only be provided if the status was 'ok'
		-- errorMsg (string) A string describing the error that occurred
			-- This parameter should only be provided if the status was 'error'.
	
	getCaptureInfo = LeicaTetherTask.getCaptureInfo,
	
	
--------------------------------------------------------------------------------
--- Host is asking plugin to start downloading the image from the camera.
 -- <p>First supported in version 3.0 of the Lightroom SDK.</p>
	-- @name TetherTask.startDownload
	-- @class function
	-- @param deviceId (string) The device ID
	-- @param captureId (string) The capture ID provided by the plugin 
		-- when doCapture was called
	-- @return none
	
	startDownload = LeicaTetherTask.startDownload,
	
--------------------------------------------------------------------------------
	
}


